#include <dci.h>
#include <p30fxxxx.h>

/* DCI is enabled only for following devices */
#if defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) ||defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6014__)

/*********************************************************************
*    Function Name : ReadDCI
*    Description   : This routine returns the data stored in one of
*		     the receive buffers based on the buffer number
*    Return Value  : unsigned int buffer content
*    Parameters    : unsigned char: buffer
*																	
*********************************************************************/

unsigned int ReadDCI(unsigned char buffer )
{
     return (*(&RXBUF0+ (buffer&0x3)));
}

#endif
